//---------------------------------------------------------------------------

#define MAX 10000

//---------------------------------------------------------------------------

#pragma hdrstop

#include <iostream>
#include <fstream>

#include "heap.h"   //klasa CHeap
#include "graph.h"  //klasa Graph

using namespace std;

//---------------------------------------------------------------------------

int TEMP[MAX], VAR[MAX], PS[MAX];
bool DEL[MAX];

void cleanit() {
    for (int i = 0; i < MAX; i++) {
        TEMP[i] = MOD[i] = PS[i] = 0;
        VAR[i] = INT_MAX;          //"nieskonczonosc"
    }
}

//---------------------------------------------------------------------------

void main(int argc, char *argstr[])
{

    cleanit();  //inicjalizacja tablic do wartosci domyslnych

    Graph G;
    G.init("DROZ1.DAT"); // rozw:  200 238 178 1438 674 562 2959 1302
    G.show();



    CHeapInxDyn KDyn;
    KDyn.init(TEMP,VAR,PS);
    KDyn.clear();

    for (int i = 0; i < G.n; i++)       //dodajemy wezly grafu
        KDyn.add(i);

    KDyn.mod(0,0);                      //punkt startowy
    int a,b;
    while (!KDyn.empty()) {             //dopoki kopiec nie jest pusty

          a = KDyn.delroot();           //usun korzen
          DEL[a] = 1;                     //ustawia flag - usunity
          b = G.first(a);                 //b - indeks usunitego korzenia

          while ( b != a ) {                //przegld po wzach incydentnych do a

                int next = G.g[b];        //numer kolejnego incydentnego (do a) wza
                int weight = G.g[b+1];    //waga tej sciezki

                if ( VAR[next] > weight && DEL[next] == 0 ) //jezeli ma mniejsz wag i nie byl usuniety
                    KDyn.mod(next,weight);   //modyfikuj wag poczenia

                G.next(b);              //przejdz do kolejnego wezla incydentnego
          }
    }

	int sum = 0;

	for (int i=0; i < G.n; i++)         //sumuje wagi sciezek nalezacych do drzewa
        sum+=VAR[i];

	cout << "Suma wag sciezek wchodzacych w skad drzewa wynosi: " << sum << endl;
    system ("pause");
}
//---------------------------------------------------------------------------

